//
//  GHDevice+Custom.h
//  Garmin Health
//
//  Created by Echeandia, Augie on 11/17/17.
//  Copyright © 2017 Garmin International, Inc. or its affiliates. All rights reserved.
//

#import "GHDevice.h"
#import "GHCustomFITSettings.h"
#import "GHCustomAccelerometerSettings.h"
#import "GHCustomTimeSettings.h"


/**
 *  Type definition for Block.
 */
typedef void (^GHIDHash)(NSNumber *unitID);

/**
  *  Type definition for Block.
  */
typedef void (^GHFITSettings)(GHCustomFITSettings *settings, NSError *error);

/**
 *  Type definition for Block.
 */
typedef void (^GHAccelerometerSettings)(GHCustomAccelerometerSettings* settings, NSError *error);

/**
 *  Type definition for Block.
 */
typedef void (^GHCustomError)(NSError *error);


#pragma mark - Methods
/**
 *  Extension of GHDevice class.
 */
@interface GHDevice (Custom)

/**
 *  Update the FIT settings on the device.
 *  @param customSettings GHCustomFITSettings to deliver to the device.
 *  @param completionHandler GHCustomError block that is called with the results of the call.
*/
- (void)updateFITSettings:(GHCustomFITSettings *)customSettings completion:(GHCustomError)completionHandler;

/**
 *  Retrieves the FIT settings from the device.
 *  @param completionHandler GHFITSettings block that is called when settings have
 *  been retrieved from the device.
 */
- (void)getFITSettings:(GHFITSettings)completionHandler;

/**
 *  Update the accelerometer settings on the device.
 *  @param customSettings GHCustomAccelerometerSettings to deliver to the device.
 *  @param completionHandler GHCustomError block that is called with the results of the call.
*/
- (void)updateAccelerometerSettings:(GHCustomAccelerometerSettings *)customSettings completion:(GHCustomError)completionHandler;

/**
 *  Retrieves the accelerometer settings from the device.
 *  @param completionHandler GHAccelerometerSettings block that is called when settings have
 *  been retrieved from the device.
 */
- (void)getAccelerometerSettings:(GHAccelerometerSettings)completionHandler;

/**
 *  Update the time settings on the device.
 *  @param customSettings GHCustomTimeSettings to deliver to the device.
 *  @param completionHandler GHCustomError block that is called with the results of the call.
*/
- (void)updateTimeSettings:(GHCustomTimeSettings *)customSettings completion:(GHCustomError)completionHandler;

/**
 *  Sends FIT activation to device which results in the display of custom screens.
 *  @deprecated Use unitIDWithCompletion: instead
 */
- (void)sendActivation DEPRECATED_MSG_ATTRIBUTE("Use unitIDWithCompletion: instead.");

/**
 *  Sends FIT activation to device which results in the display of custom screens  on the device
 *  and provides the unit ID in the GHHash block. GHHash block will contain a -1 if an error occured.
 *  @param hash GHIDHash block that is called to further hash the unit ID.
 */
- (void)unitIDWithCompletion:(GHIDHash)hash;


@end
